# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(base.pm) perl(open.pm) perl(overload.pm) perl(AnyEvent.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name AnyEvent-Callback
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: callback aggregator for L<AnyEvent> watchers.
Group: Development/Perl
License: perl
URL: https://github.com/unera/libanyevent-callback

Source0: http://cpan.org.ua/authors/id/U/UN/UNERA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The module allows You to create callback's hierarchy. Also the module groups.error and result callbacks into one object.

Also the module checks if one callback was called by watcher or not.
If a watcher doesn't call result or error callback, error callback will be
called automatically.

Also the module checks if a callback was called reentrant. In the case the
module will complain (using the carp entry in the Carp manpage).

If a watcher touches error callback and if superior didn't define error
callback, the module will call error callback upwards hierarchy. Example:

    AE::something @args, CB \&my_watcher, \&on_error;

    sub on_error {

    }

    sub my_watcher {
        my $cb = pop;

        ...

        the_other_watcher $cb->CB( sub { # error callback wasn't defined
            my $cb = pop;
            ...
            yet_another_watcher1 $cb->CB( sub {
                my $cb = pop;
                ...
                $cb->( 123 );   # upwards callback

            });
            yet_another_watcher2 $cb->CB( sub {
                my $cb = pop;
                ...

                $cb->error( 456 );  # on_error will be called

            });
        });
    }



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/A*

%changelog
