%define module_name AnyEvent-HTTPD-SendMultiHeaderPatch
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent/HTTPD.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001003
Release: alt2
Summary: Patch (hack) of AnyEvent::HTTPD for sending multiple headers with the same field name.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CI/CINDY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use AnyEvent::HTTPD; # Optional,
                         # because the patch module will use it first.
    use AnyEvent::HTTPD::SendMultiHeaderPatch;

    # In the http request handler,
    # separate the multiple values of the same field with \0 character.
    sub {
        my($httpd, $req) = @_;
        # ...
        $req->respond(
            200, 'OK', {
                'Set-Cookie' => "a=123; path=/; domain=.example.com\0b=456; path=/; domain=.example.com"
            }, "Set the cookies"
        );
    }

    # Or use the added util function header_add in AnyEvent::HTTPD::Util.
    use AnyEvent::HTTPD::Util;

    sub {
        my($httpd, $req) = @_;
        # ...
        my %%%%header;
        header_add(\%%%%header, 'Set-Cookie', 'a=123; path=/; domain=.example.com');
        header_add(\%%%%header, 'Set-Cookie', 'b=456; path=/; domain=.example.com');
        $req->respond(200, 'OK', \%%%%header, "Set the cookies");
    }

    # There also introduced another util function header_gets in AnyEvent::HTTPD::Util,
    # to extract multiple values in the header
    sub {
        my($httpd, $req) = @_;
        # ...
        my %%%%header;
        header_add(\%%%%header, 'Example', 'a');
        header_add(\%%%%header, 'Example', 'b');

        my $example_values = header_gets(\%%%%header, 'Example');
        # get ['a', 'b']
        my $no_values = header_gets(\%%%%header, 'None');
        # get []
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
