# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/Handle.pm) perl(AnyEvent/Socket.pm) perl(Data/Dump.pm) perl(Encode.pm) perl(JSON/XS.pm)
# END SourceDeps(oneline)
%define module_name AnyEvent-Sway
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt1
Summary: communicate with the Sway window manager
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JO/JOHNMERTZ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module connects to the Sway window manager using the UNIX socket based
IPC interface it provides (if enabled in the configuration file). You can
then subscribe to events or send messages and receive their replies.

    use AnyEvent::Sway qw(:all);

    my $sway = sway();

    $sway->connect->recv or die "Error connecting";
    say "Connected to Sway";

    my $workspaces = $sway->message(TYPE_GET_WORKSPACES)->recv;
    say "Currently, you use " . @{$workspaces} . " workspaces";

...or, using the sugar methods:

    use AnyEvent::Sway;

    my $workspaces = Sway->get_workspaces->recv;
    say "Currently, you use " . @{$workspaces} . " workspaces";

A somewhat more involved example which dumps the Sway layout tree whenever there
is a workspace event:

    use Data::Dumper;
    use AnyEvent;
    use AnyEvent::Sway;

    my $sway = sway();

    $sway->connect->recv or die "Error connecting to Sway";

    $sway->subscribe({
        workspace => sub {
            $sway->get_tree->cb(sub {
                my ($tree) = @_;
                say "tree: " . Dumper($tree);
            });
        }
    })->recv->{success} or die "Error subscribing to events";

    AE::cv->recv

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
