%define module_name AnySan-Provider-Slack
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent/HTTP.pm) perl(AnyEvent/SlackRTM.pm) perl(AnySan.pm) perl(Encode.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: AnySan provider for Slack
Group: Development/Perl
License: perl
URL: https://github.com/shogo82148/p5-AnySan-Provider-Slack

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SH/SHOGO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use AnySan;
  use AnySan::Provider::Slack;
  my $slack = slack(
      token => 'YOUR SLACK API TOKEN',
      channels => {
          'general' => {},
      },

      as_user => 0, # post messages as bot (default)
      # as_user => 1, # post messages as user

      subtypes => [], # ignore all subtypes (default)
      # subtypes => ['bot_message'], # receive messages from bot
      # subtypes => ['all'], # receive all messages(bot_message, me_message, message_changed, etc)
  );
  $slack->send_message('slack message', channel => 'C024BE91L');

  AnySan->register_listener(
      slack => {
          event => 'message',
          cb => sub {
              my $receive = shift;
              return unless $receive->message;
              warn $receive->message;
              warn $receive->attribute->{subtype};
              $receive->send_reply('hogehoge');
          },
      },
  );


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/A*

%changelog
