# BEGIN SourceDeps(oneline):
BuildRequires: perl(Apache2/RequestIO.pm) perl(Apache2/RequestUtil.pm) perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name Apache-EmbeddedPerl-Lite
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: light weight embedded perl parser
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MIKER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This modules is a light weight perl parser designed to be used in
conjunction wit mod_perl and Apache 1 or Apache 2. It may be used as a
handler for files containing embedded perl or it may be called as a
subroutine to conditionally parse files of your choosing.

Perl code may be embedded in a file parsed by this module as described
below. Each section of perl code is collected and eval'd as a subroutine that
is passed the two arguments ($classnam,$r) in its input array @_;

Embedded perl should have the following format:

  On a line by itself:

  {optional whitespace}  <!-- {whitespace} perl 

  perl code here

# terminating bracket on a line by itself
  {optional whitespace} -->

The beginning and terminating brackets may optionally be followed by a white
space and comments, which will be ignored.

  i.e.

  <!--  perl
# perl code goes here, it will be executed as a subroutine
#
# anon_sub($classname,$r) {
      my($class,$r) = @_;
      $r->print("Hello World, I am in package $class\n");
# }
  -->

=item * $http_response = handler($classname,$r);

The function "handler" has the prototype:

_handler ($$) : method {

which receives the arguments $class, $r from Apache mod_perl.

  input:_class name,_(a scalar, not a ref)
__request handle

  return:_Apache response code or undef

  handler is not exported.

Expected Codes:

_  0_OK
_404_File Not Found
_500_Server Error

  404 could not find, open, etc... file
  500 missing closing embedded perl bracket
      embedded perl has an error

When a 500 error is returned, a warning will be issued to STDERR providing
details about the error.
_
A ContentType header will not be sent unless the type is specified as
follows:

_PerlSetVar_ContentType_text/html

mod_perl configuration is as follows:

  PerlModule Apache::EmbeddedPerl::Lite

  <Files *.ebhtml>
    SetHandler perl-script
    PerlHandler Apache::EmbeddedPerl::Lite
    PerlSetVar ContentType text/html
  </Files>

=item * $http_response = embedded($classname,$r,$file,@args);

The function "embedded" is similar to "handler" above except that it does not send any headers.
Headers are the responsibility of the application "handler", or the embedded
code.

@args are optional arguments that may be passed from your handler to embedded.

  input:_class name,_(a scalar, not a ref)
__request handle,
__file name
__@args_[optional] appication specific

  return:_Apache response code or undef

  ... at startup or .httaccess ...

  use Apache::EmbeddedPerl::Lite qw(embedded);

  ... in the application handler ...

_if ($r->filename =~ /\.ebhtml$/) {
  ..._  set content type, etc...

_  $response = embedded(__PACKAGE__,$r,$r->filename);
_} else {
_  $response = embedded(__PACKAGE__,$r,$someotherfile);
_}
_return $response if $response; # contains error

  ..._  do something else
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
