Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(DBD/Cassandra.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-Apache-Session-Browseable
Version:	1.3.13
Release:	alt1_4
Summary:	Add index and search methods to Apache::Session
License:	GPL-1.0-or-later OR Artistic-1.0-Perl
URL:		https://metacpan.org/release/Apache-Session-Browseable
Source0:	https://cpan.metacpan.org/modules/by-module/Apache/Apache-Session-Browseable-%{version}.tar.gz
Patch0:		Apache-Session-Browseable-1.3.6-synopsis-cafile.patch
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(Module/Build.pm)
# Module Runtime
BuildRequires:	perl(Apache/Session.pm)
BuildRequires:	perl(Apache/Session/Generate/MD5.pm)
BuildRequires:	perl(Apache/Session/Lock/File.pm)
BuildRequires:	perl(Apache/Session/Lock/Null.pm)
BuildRequires:	perl(Apache/Session/Serialize/Base64.pm)
BuildRequires:	perl(Apache/Session/Serialize/Storable.pm)
BuildRequires:	perl(Apache/Session/Serialize/Sybase.pm)
BuildRequires:	perl(Apache/Session/Store/DBI.pm)
BuildRequires:	perl(Apache/Session/Store/File.pm)
BuildRequires:	perl(Apache/Session/Store/Informix.pm)
BuildRequires:	perl(Apache/Session/Store/MySQL.pm)
BuildRequires:	perl(Apache/Session/Store/Oracle.pm)
BuildRequires:	perl(Apache/Session/Store/Postgres.pm)
BuildRequires:	perl(Apache/Session/Store/Sybase.pm)
BuildRequires:	perl(AutoLoader.pm)
BuildRequires:	perl(base.pm)
BuildRequires:	perl(DBI.pm)
BuildRequires:	perl(Digest/SHA.pm)
BuildRequires:	perl(JSON.pm)
BuildRequires:	perl(MIME/Base64.pm)
BuildRequires:	perl(Net/LDAP.pm)
BuildRequires:	perl(Net/LDAP/Util.pm)
BuildRequires:	perl(Redis.pm)
BuildRequires:	perl(Storable.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(vars.pm)
# Test Suite
BuildRequires:	perl(Data/Dumper.pm)
BuildRequires:	perl(File/Path.pm)
BuildRequires:	perl(File/Temp.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(utf8.pm)
BuildRequires:	perl(warnings.pm)
# Optional Tests
BuildRequires:	perl(DBD/mysql.pm)
BuildRequires:	perl(DBD/SQLite.pm)
# Dependencies
Requires:	perl(MIME/Base64.pm)
Requires:	perl(Redis.pm)
Requires:	perl(Storable.pm)
Source44: import.info

%description
A virtual Apache::Session back-end providing some class methods to manipulate
all sessions and add the capability to index some fields to make re-search
faster.

%prep
%setup -q -n Apache-Session-Browseable-%{version}

# Fix certificate bundle location in SYNOPSIS
%patch0 

%build
perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} -c %{buildroot}

%check
./Build test

%files
%doc --no-dereference COPYRIGHT LICENSE
%doc Changes README.md
%{perl_vendor_privlib}/Apache/
%{perl_vendor_privlib}/auto/Apache/

%changelog
