%define module_name Apache2-AuthCookieDBI
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Apache/AuthCookie/Util.pm) perl(Text/TagTemplate.pm) perl-devel
# END SourceDeps(oneline)
%define upstream_name    Apache2-AuthCookieDBI
%define upstream_version 2.17

Name:       perl-%{upstream_name}
Version:    2.19
Release:    alt1

Summary:    An AuthCookie module backed by a DBI database
License:    lgpl
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MATISSE/%{module_name}-%{version}.tar.gz

BuildRequires: perl(Apache2/AuthCookie.pm)
BuildRequires: perl(Apache2/Const.pm)
BuildRequires: perl(Apache2/RequestRec.pm)
BuildRequires: perl(Apache2/ServerUtil.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Crypt/CBC.pm)
BuildRequires: perl(DBI.pm)
BuildRequires: perl(Date/Calc.pm)
BuildRequires: perl(Digest/MD5.pm)
BuildRequires: perl(Digest/SHA.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(FindBin.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(mod_perl2.pm)
BuildArch:  noarch
Source44: import.info

%description
Apache2::AuthCookieDBI is a module that subclasses Apache2::AuthCookie and is
designed to be directly used for authentication in a mod_perl server.

It is a ticket-issuing system that looks up username/passwords in a DBI
database using generic SQL and issues MD5-checksummed tickets valid for
a configurable time period.  Incoming requests with tickets are
checksummed and expire-time checked.

%prep
%setup -q -n %{module_name}-%{version}

%build
%{__perl} Makefile.PL INSTALLMAN1DIR=%_man1dir INSTALLDIRS=vendor
%make

%check
make test

%install
%makeinstall_std

%files
%doc README README-docker techspec.txt Changes generic_reg_auth_scheme.txt LICENSE
%{perl_vendor_privlib}/Apache2

%changelog
