# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Benchmark.pm) perl(Class/Accessor.pm) perl(Class/Accessor/Classy.pm) perl(Class/Accessor/Complex.pm) perl(Class/Accessor/Constructor.pm) perl(Class/Accessor/Fast.pm) perl(Class/Accessor/Fast/XS.pm) perl(Class/Accessor/Lite.pm) perl(Class/MethodMaker.pm) perl(Class/Spiffy.pm) perl(Class/XSAccessor.pm) perl(Class/XSAccessor/Array.pm) perl(Class/XSAccessor/Compat.pm) perl(Module/Build/Tiny.pm) perl(Mojo/Base.pm) perl(Moose.pm) perl(Mouse.pm) perl(Object/Tiny.pm) perl(Rose/Object.pm) perl(Rose/Object/MakeMethods/Generic.pm) perl(Rubyish/Attribute.pm) perl(Spiffy.pm) perl(Test/Pod.pm) perl(accessors.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name App-Benchmark-Accessors
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.00
Release: alt1
Summary: Benchmark accessor generators
Group: Development/Perl
License: perl
URL: https://github.com/marcelgruenauer/App-Benchmark-Accessors

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MARCEL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution runs benchmarks on various accessor generators. The
following generators are being benchmarked:

=over 4

=item Moose

mutable and immutable

=item Mouse

mutable and immutable

=item Class::Accessor

=item Class::Accessor::Fast

=item Class::Accessor::Fast::XS

=item Class::XSAccessor::Compat

=item Class::Accessor::Complex

=item Class::Accessor::Constructor

=item Class::Accessor::Classy

=item Class::Accessor::Lite

=item Mojo::Base

=item Class::MethodMaker

=item Object::Tiny

=item Spiffy

=item Class::Spiffy

=item `accessors'

=item Class::XSAccessor

=item Class::XSAccessor::Array

=item Object::Tiny

=item Rose

=item Rubyish::Attribute

=back

The benchmarks are being run as part of the test suite; see the App::Benchmark manpage.
This way you can look at this distribution's CPAN testers page to see the
benchmark results on many different platforms and for many different perl
versions.

The `t/construction.t' file benchmarks object creation, `t/get.t' benchmarks
getter methods and `t/set.t' benchmarks setter methods.

Not every benchmark is run on every module; for example, the Object::Tiny manpage
doesn't create setter methods, and the accessors manpage doesn't generate constructors.

Each benchmark test file takes an optional numeric parameter that is used as
the number of iterations.

It's probably a good idea not to read too much into these benchmarks; they
could be seen as micro-optimization. However, if you have a complex object
hierarchy and create lots of objects and run many many getters/setters on
them, they could help to save some time. But be sure to use the Devel::NYTProf manpage
first to see where your real bottlenecks are.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes
%perl_vendor_privlib/A*

%changelog
