%define module_name App-CELL
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Date/Format.pm) perl(File/HomeDir.pm) perl(File/Next.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Log/Any.pm) perl(Log/Any/Adapter.pm) perl(Log/Any/Test.pm) perl(Module/Build.pm) perl(Params/Validate.pm) perl(Software/License.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(Test/Perl/Critic.pm) perl(Test/Warnings.pm) perl(Try/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.231
Release: alt1
Summary: Configuration, Error-handling, Localization, and Logging
Group: Development/Perl
License: bsd
URL: https://sourceforge.net/projects/perl-cell/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SM/SMITHFARM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is the top-level module of App::CELL, the Configuration,
Error-handling, Localization, and Logging framework for Perl
applications running under Unix-like systems such as SUSE Linux
Enterprise.

Configuration, error-handling, localization, and logging may seem like
diverse topics. In the author's experience, however, applications written
for "users" (however that term may be defined) frequently need to:

=over

=item 1. be configurable by the user or site administrator

=item 2. handle errors robustly, without hangs and crashes

=item 3. potentially display messages in various languages

=item 4. log various types of messages to syslog

=back

Since these basic functions seem to work well together, CELL is designed to
provide them in an integrated, well-documented, straightforward, and
reusable package.

For details, see the CELL Guide (in `doc/')

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README.rst LICENSE CONTRIBUTING.rst
%perl_vendor_privlib/A*
%perl_vendor_privlib/auto/*

%changelog
