%define module_name App-Dapper
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(Data/Dumper.pm) perl(Data/Dumper/HTML.pm) perl(DateTime.pm) perl(DateTime/Format/XSD.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(File/Monitor.pm) perl(File/Path.pm) perl(File/Spec/Functions.pm) perl(FindBin.pm) perl(Getopt/Mixed.pm) perl(IO/Dir.pm) perl(JSON.pm) perl(Net/HTTPServer.pm) perl(POSIX.pm) perl(Pod/Usage.pm) perl(Template/Alloy.pm) perl(Template/Constants.pm) perl(Test.pm) perl(Test/More.pm) perl(Text/Markdown.pm) perl(Text/MultiMarkdown.pm) perl(Unicode/Normalize.pm) perl(YAML/PP.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.21
Release: alt1
Summary: A publishing tool for static websites.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MD/MDB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Dapper helps you build static websites. To get you started, you can use the
`dapper init' command to initialize a directory. After running this command,
the following directory structure will be created:

    _config.yml
    _layout/
        index.html
    _source/
        index.md

In that same directory, you may then build the site using the `dapper build'
command, which will combine the source files and the layout files and place
the results in the output directory (default: `_output'). After you build
the default site, you'll then have the following directory structure:

    _config.yml
    _layout/
        index.html
    _source/
        index.md
    _output/
        index.html

To see what your website looks like, run the `dapper serve' command which
will spin up a development webserver and serve the static files located in
the output directory (default: `_output') at http://localhost:8000.

Now, let's walk through each file:

=over 4

=item _config.yml

The configuration file is a YAML file that specifies key configuration
elements for your static website. The default configuration file is as
follows:

    ---
    name : My Site

If you want to use a separate source, layout, or output directory, you may
specify it in this file. For instance:

    ---
    name : My Site
    source : _source
    layout : _layout
    output : _output

All of the configurations in this file are available in layout templates,
based on the Liquid template system. For instance, `name' in the
configuration file may be used in a template as follows:

    {{ site.name }}

=item _source/index.md

A sample markdown file is available in the _source directory. Contents:

    ---
    layout: index
    title: Welcome
    ---

    Hello world.

There are a few things to note about this file:

=over 4

=item 1. There is a YAML configuration block at the start of the file.

=item 2. The *layout* configuration specifies which layout to use.

=item 3. The `index' layout indicates that `_layout/index.html' should be used.

=item 4. The `title' configuration is the name of the post/page. It is optional.

=item 5. All of the configurations may be used in the corresponding layout file.

    <!-- Example use of "name" in a layout file -->
    <h1>{{ page.name }}</h1>

=back

=item _layout/index.html

Layout files are processed using the Liquid template system. The initial layout
file that is given after you run the `dapper init' command, is this:

    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
    <html>
    <head>
      <title>{{ page.title }}</title>
      <meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
    </head>

    <body>

    {{ page.content }}

    </body>
    </html>

The main content of the text file that is being rendered with this template
is available using `{{ page.content }}'.

Definitions specified in the `_config.yml' file can be referenced under the
"site" namespace (e.g. {{ site.name }}. Definitions specified in the YAML
portion of text files can be referenced under the "page" namespace (e.g.
{{ page.title }}.

=item _output/index.html

The output file that is created is a mix of the input file and the layout that
is specified by the input file. For the default site, the following output
file is created:

    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
    <html>
    <head>
      <title>Welcome</title>
      <meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
    </head>

    <body>

    <p>Hello world.</p>

    </body>
    </html>

=back

Dapper provides a number of optional command line switches:

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
