%define module_name App-Docker-Client
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/HTTP.pm) perl(AnyEvent/Socket.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP/Protocol/http/SocketUnixAlt.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.010300
Release: alt1
Summary: Simple and plain Docker client!
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MZ/MZIESCHA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Sample to inspect a conatainer, for mor posibilities see at the Docker API
documentation https://docs.docker.com/engine/api/v1.25/

    use App::Docker::Client;

    my $client = App::Docker::Client->new();

    my $hash_ref = $client->get('/containers/<container_id>/json');

Create a new container:
    
    $client->post('/containers/create', {}, {
        Name      => 'container_name',
        Tty       => 1,
        OpenStdin => 1,
        Image     => 'perl',
    });

For a remote authority engine use it like that:

    use App::Docker::Client;
    
    my %%hash = ( authority => '0.0.0.0:5435' );

    my $client = App::Docker::Client->new( %%hash );

    my $hash_ref = $client->get('/containers/<container_id>/json');
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/A*

%changelog
