%define module_name App-EUMM-Upgrade
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(Github/Fork/Parent.pm) perl(List/Util.pm) perl(Perl/Meta.pm) perl(Test/More.pm) perl(Text/FindIndent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: Perl tool to upgrade ExtUtils::MakeMaker-based Makefile.PL
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CH/CHORNY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
eumm-upgrade is a tool to allow using new features of ExtUtils::MakeMaker without losing.
compatibility with older versions. It adds compatibility code to Makefile.PL and
tries to automatically detect some properties like license, minimum Perl version required and
repository used.

Just run eumm-upgrade.pl in directory with Makefile.PL. Old file will be copied to Makefile.PL.bak.
If you use Github, Internet connection is required.

You need to check resulting Makefile.PL manually as transformation is done
with regular expressions.

If you need to declare number of spaces in indent in Makefile.PL, use following string at start of
it (set 'c-basic-offset' to your value):

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name

# -*- mode: perl; c-basic-offset: 4; indent-tabs-mode: nil; -*-


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*
%changelog
