%define module_name App-Elog
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: An Apache error log viewer
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JA/JACOBG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This program will show the Apache error log associated with the
directory you are currently inside of.

Many people set up web servers with each website inside their own
directory in $HOME or /var/www. While working on these sites, for
example /var/www/coolsite.com/, you can run `elog` with no arguments
and it will show the error log for that site inside of less(1).

If you define the $PAGER environment variable, `elog` will use that
program instead of less(1).

If you want to view another site's error log, provide `elog` with an
expression that partially matches the name of that website's log
after the `elog` command. For example, `elog foo`.

To see a list of all the error logs on the server use `elog -l`.
More detailed information, such as what rotations exist for each
log, use `elog -ll`.

To specify an older rotation of an error log, use the -r option.
For example `elog -r2`, might show the /var/log/httpd/foo.error_log.2.gz
file.

The way it determines which error log to show is by parsing Apache
config files in either /etc/httpd or /etc/apache2. An ErrorLog line
tells where the error log is, a DocRoot line tells which directory
that error log is for.

The -p option will show the path the selected error log file.

The -f option will open the log in `tail -f`.

The -v option will open the log in `vim`.

The -i option will show statistics about the error log file such
as how many errors there were and what time frame.

The -a option will show the message of the error on it's own line,
with extra info such as date and ip address on a line beforehand.
When multiple lines of the error log relate to the same error, they
are grouped.

The -g option will show a graph of the number of errors in an hourly
interval.

The -gd option will show a graph of the number of errors in a daily
interval.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*
%_man1dir/*
%_bindir/*

%changelog
