%define module_name App-Games-Keno
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Compare.pm) perl(List/Util.pm) perl(Moose.pm) perl(Scalar/Util.pm) perl(Test2/V0.pm) perl(Types/Standard.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.222540
Release: alt1
Summary: Plays Keno
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TY/TYUPYRCML/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package plays a game of Keno.

Call "Playkeno" like this to play 1000 draws with five spots.
 
 App::Games::Keno::PlayKeno(5, 1000);
 
Example results:

 You are playing 1,000 draws with 5 spots: 22  35  37  72  76
 
 You played 1,000 draws with 5 spots: 22  35  37  72  76
 You won 112 of 1,000 draws.  (1 in 8.93)
 0:213  1:410  2:265  3:94  4:18  5:0  
 Total winnings: $512  Net Gain: -488  Loss ratio: 1.95

If you wish to see the results of each draw, turn on the verbose option:

 App::Games::Keno::PlayKeno(5, 10, 'true');

Sample abbreviated results with verbose option:

 You are playing 10 draws with 5 spots: 7  14  18  27  71
 
 Starting draw 1...
 Drawn Numbers:   1  12  16  22  23  25  27  30  31  32  33  34  38  40  47  52  57  60  64  69
 Matched Numbers: 27
 Draw 1 matches 1 of 5 spots, but there is no payout for that.  You LOSE!
 Gain:       -1  Total Winnings:     0
 
 Starting draw 2...
 Drawn Numbers:   3  10  15  22  23  27  32  33  36  38  40  41  42  48  53  56  59  66  75  77
 Matched Numbers: 27
 Draw 2 matches 1 of 5 spots, but there is no payout for that.  You LOSE!
 Gain:       -2  Total Winnings:     0
 
  (draws 3-9 not shown in this example)
 
 Starting draw 10...
 Drawn Numbers:   5  7  11  13  14  16  21  25  26  29  33  46  48  52  55  61  66  69  71  76
 Matched Numbers: 7  14  71
 Draw 10 matches 3 of 5 spots.  You win $2
 Gain:       -6  Total Winnings:     4
  
 
 You played 10 draws with 5 spots: 7  14  18  27  71
 You won 2 of 10 draws.  (1 in 5.00)
 0:2  1:2  2:4  3:2  4:0  5:0  
 Total winnings: $4  Net Gain: -6  Loss ratio: 2.50

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE
%perl_vendor_privlib/A*

%changelog
