%define module_version 1.0.3
%define module_name App-GitHooks-Plugin-DetectCommitNoVerify
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/GitHooks.pm) perl(Capture/Tiny.pm) perl(Git/Repository.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Test/Requires/Git.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.3
Release: alt1
Summary: Find out when someone uses --no-verify and append the pre-commit checks to the commit message.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/App-GitHooks-Plugin-DetectCommitNoVerify

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
Sometimes you just have to use `--no-verify' to get past the checks and commit
as fast as possible. To prevent this from being too tempting, this plugin
checks when you use --no-verify and runs the pre-commit checks if you've
skipped them. It will let you commit even if the pre-commit checks fail, but it
will add their output to the commit message for posterity (and public shaming).
%prep
%setup -q -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes example
%perl_vendor_privlib/A*

%changelog
