%define module_version 1.1.1
%define module_name App-GitHooks-Plugin-NotifyReleasesToSlack
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/GitHooks.pm) perl(CPAN/Changes.pm) perl(Data/Dumper.pm) perl(Git/Repository.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Log/Any.pm) perl(Module/Build.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Test/Requires/Git.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.1
Release: alt1
Summary: Notify Slack channels of new releases pushed from a repository.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/App-GitHooks-Plugin-NotifyReleasesToSlack

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
If you maintain a changelog file, and tag your release commits, you can use
this plugin to send the release notes to Slack channels.

Here is a practical scenario:

=over 4

=item 1.

Install `App::GitHooks::Plugin::NotifyReleasesToSlack'.

=item 2.

Set up an incoming webhook in Slack. This should give you a URL to post
messages to, with a format similar to
`https://hooks.slack.com/services/.../.../...'.

=item 3.

Configure the plugin in your `.githooksrc' file:

_[NotifyReleasesToSlack]
_slack_post_url = ...
_slack_channels = #releases, #test
_changelog_path = Changes

=item 4.

Add release notes in your changelog file:

_v1.0.0  2015-04-12
_        - Added first feature.
_        - Added second feature.

=item 5.

Commit your release notes:

_git commit Changelog -m 'Release version 1.0.0.'

=item 6.

Tag your release:

_git tag v1.0.0
_git push origin v1.0.0

=item 7.

Watch the notification appear in the corresponding Slack channel(s):

_release-notes BOT: @channel - Release v1.0.0 of test_repo:
_- Added first feature.
_- Added second feature.

=back
%prep
%setup -q -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md example
%perl_vendor_privlib/A*

%changelog
