# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Greple.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name App-Greple-jq
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: greple module to search JSON data with jq
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/greple-jq

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is an experimental module for the App::Greple manpage to search JSON
formatted text using the jq(1) manpage as a backend.

Search top level json object which includes both `Marvin' and
`Zaphod' somewhere in its text representation.

    greple -Mjq 'Marvin Zaphod'

You can search object `.commit.author.name' includes `Marvin' like this:

    greple -Mjq --IN .commit.author.name Marvin

Search first `name' field including `Marvin' under `.commit':

    greple -Mjq --IN .commit..name Marvin

Search any `author.name' field including `Marvin':

    greple -Mjq --IN author.name Marvin

Search `name' is `Marvin' and `type' is `Robot' or `Android':

    greple -Mjq --IN name Marvin --IN type 'Robot|Android'

Please be aware that this is just a text matching tool for indented
result of the jq(1) manpage command.  So, for example, `.commit.author'
includes everything under it and it matches `committer' field name.
Use the jq(1) manpage filter for more complex and precise operation.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/A*

%changelog
