%define module_name App-Greple-tee
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Greple.pm) perl(App/sdif.pm) perl(Data/Section/Simple.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(Unicode/EastAsianWidth.pm) perl(Util.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: module to replace matched text by the external command result
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/App-Greple-tee

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Greple's -Mtee module sends matched text part to the given filter
command, and replace them by the command result.  The idea is derived
from the command called teip.  It is like bypassing partial data to
the external filter command.

Filter command is specified as following arguments after the module
option ending with `--'.  For example, next command call command
`tr' command with `a-z A-Z' arguments for the matched word in the
data.

    greple -Mtee tr a-z A-Z -- '\w+' ...

Above command convert all matched words from lower-case to upper-case.
Actually this example is not useful because greple can do the same
thing more effectively with --cm option.

By default, the command is executed as a single process, and all
matched data is sent to it mixed together.  If the matched text does
not end with newline, it is added before and removed after.  Data are
mapped line by line, so the number of lines of input and output data
must be identical.

Using --discrete option, individual command is called for each
matched part.  You can notice the difference by following commands.

    greple -Mtee cat -n -- copyright LICENSE
    greple -Mtee cat -n -- copyright LICENSE --discrete

Lines of input and output data do not have to be identical when used
with --discrete option.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md README.ZH.md README.KO.md README.JA.md docs
%perl_vendor_privlib/A*

%changelog
