%define module_name App-Greple-xlate
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Greple.pm) perl(App/Greple/msdoc.pm) perl(App/optex/textconv.pm) perl(App/sdif.pm) perl(Clipboard.pm) perl(Encode.pm) perl(File/Share.pm) perl(Hash/Util.pm) perl(JSON.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(Text/ANSI/Fold.pm) perl(Unicode/EastAsianWidth.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3101
Release: alt1
Summary: translation support module for greple
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/App-Greple-xlate

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Greple xlate module find text blocks and replace them by the
translated text.  Currently only DeepL service is supported by the
xlate::deepl module.

If you want to translate normal text block in the pod manpage style document,
use greple command with `xlate::deepl' and `perl' module like
this:

    greple -Mxlate::deepl -Mperl --pod --re '^(\w.*\n)+' --all foo.pm

Pattern `^(\w.*\n)+' means consecutive lines starting with
alpha-numeric letter.  This command show the area to be translated.
Option --all is used to produce entire text.

=for html <p>
<img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/select-area.png">
</p>

Then add `--xlate' option to translate the selected area.  It will
find and replace them by the deepl command output.

By default, original and translated text is printed in the "conflict
marker" format compatible with the git(1) manpage.  Using `ifdef' format, you
can get desired part by the unifdef(1) manpage command easily.  Format can be
specified by --xlate-format option.

=for html <p>
<img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/format-conflict.png">
</p>

If you want to translate entire text, use --match-entire option.
This is a short-cut to specify the pattern matches entire text
`(?s).*'.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.gpt3-KO.md LICENSE README.gpt3-ZH.md README.gpt3-RU.md README.deepl-KO.md README.gpt4-JA.md README.md README.deepl-ZH.md Changes README.gpt3-JA.md README.gpt3-DE.md README.deepl-RU.md README.deepl-FR.md README.deepl-JA.md README.gpt3-FR.md README.deepl-DE.md
%perl_vendor_privlib/A*
%perl_vendor_privlib/auto/*
%_man1dir/*
%_bindir/*

%changelog
