%define module_name App-Notifier-Service
# BEGIN SourceDeps(oneline):
BuildRequires: perl(File/Spec.pm) perl(FindBin.pm) perl(HTTP/Request/Common.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON/MaybeXS.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Mojolicious/Lite.pm) perl(POSIX.pm) perl(Plack/Builder.pm) perl(Plack/Test.pm) perl(Test/More.pm) perl(YAML/XS.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0902
Release: alt1
Summary: HTTP service to notify that an event happened.
Group: Development/Perl
License: mit
URL: http://www.shlomifish.org/open-source/projects/App-Notifier/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SH/SHLOMIF/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# Prepare a YAML file in ~/.app_notifier.yml with content like this:

    $ cat <<EOF > ~/.app_notifier.yml
    commands:
        # These entries contain command lines that get invoked after the
        # notification is received. They can be either strings or arrays.
        default:
            - /home/shlomif/bin/desktop-finish-cue
        shine:
            - /home/shlomif/bin/desktop-finish-cue
            - "--song"
            - "/home/music/Music/dosd-mp3s/Carmen and Camille - Shine 4U"
            - "--message"
            - type: "text_param"
              param_name: "msg"
    EOF

    # Run the Dancer application from the distribution's root directory.
    ./bin/app.pl

    # Alternatively run the following Perl code:
    use Dancer;
    use App::Notifier::Service;
    dance;

    # When you want to notify that an event occured:
    $ curl 'http://127.0.0.1:3000/notify'
    $ curl 'http://127.0.0.1:3000/notify?cmd_id=shine'

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
