%define module_name App-OpenMbox
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: The methods for email management used in OpenMbox.net
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HE/HENRYR/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
Here are several methods used by Open Mbox, a free email provider.

    use App::OpenMbox;

    my $om = App::OpenMbox->new();

    # test purpose by providing temp files
    $om->register('/tmp/dove.db','/tmp/user.temp');
    $om->password('/tmp/dove.db','/tmp/pass.temp');

Sample input from user.temp:

    henry SomePassword111
    hello SomePassword222

Sample input from pass.temp:

    henry OldPassword111  NewPassword111
    hello OldPassword222  NewPassword222

You may know that we don't have RDB in the system for email and user management. We do not record any information about users, nor track user's behavior. For registration, user submits his/her username and password to our system, these username/password are stored in a temp file. A perl program reads data from the file, and updates its content to Dovecot's user database, which is pure text DB for email users and encrypted passwords.

To make this program work, you should have Postfix and Dovecot deployed at first. There are many documentation for how to deploy that a system.

%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes ignore.txt
%perl_vendor_privlib/A*

%changelog
