# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/SASL.pm) perl(MIME/Lite.pm) perl(MIME/Words.pm)
# END SourceDeps(oneline)
%define module_name App-OpenMbox-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: A perl client to send simple email via OpenMbox's smtp server
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HE/HENRYR/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
This module can send simple email via smtp server provided by OpenMbox or any others.

Before installation you should have Net::SSLeay pre-installed, which can be fetched by this way on Ubuntu.

    sudo apt install libnet-ssleay-perl

You can send email with OpenMbox's smtp server, which accepts smtp connection on port 587. Also you can use other provider's smtp servers, for example, gmail, pobox etc. They generally require connection to port 465 with SSL enabled.

    use App::OpenMbox::Client;

    my $client = App::OpenMbox::Client->new('user@openmbox.net','some.pass');

    # sending a plain text
    $client->sendmail(recepients => 'xx@a.com,xx@b.com',
                      type => 'text/plain',
                      subject => 'greetings',
                      body => 'how are you doing today?',
                     );

    # sending a jpeg image
    $client->sendmail(recepients => 'xx@a.com,xx@b.com',
                      type => 'image/jpeg',
                      subject => 'a picture',
                      path => '/tmp/aaa.jpeg',
                     );

    # sending with pobox's smtp server
    my $client = App::OpenMbox::Client->new('user@pobox.com','some.pass');

    $client->sendmail(recepients => 'xx@a.com,xx@b.com',
                      host => 'smtp.pobox.com',
                      port => 465,
                      ssl  => 1,
                      debug => 1,
                      type => 'text/plain',
                      subject => 'hello',
                      body => 'how are you!',
                     );

%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes ignore.txt
%perl_vendor_privlib/A*

%changelog
