%define module_name App-Phoebe
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Diff.pm) perl(Archive/Tar.pm) perl(CGI.pm) perl(CGI/Carp.pm) perl(Data/Perl/Role/Collection/Hash.pm) perl(DateTime/Format/ISO8601.pm) perl(Devel/MAT/Dumper.pm) perl(Encode.pm) perl(Encode/Locale.pm) perl(ExtUtils/MakeMaker.pm) perl(File/MimeInfo.pm) perl(File/MimeInfo/Magic.pm) perl(File/ReadBackwards.pm) perl(File/Slurper.pm) perl(HTTP/Date.pm) perl(IO/Scalar.pm) perl(IO/Socket/IP.pm) perl(IO/Socket/SSL.pm) perl(IRI.pm) perl(LWP/Parallel/UserAgent.pm) perl(LWP/UserAgent.pm) perl(MediaWiki/API.pm) perl(Modern/Perl.pm) perl(Mojolicious.pm) perl(Net/DNS.pm) perl(Net/IDN/Encode.pm) perl(Net/IP.pm) perl(Net/SSLeay.pm) perl(Pod/Checker.pm) perl(Term/ANSIColor.pm) perl(Term/ReadLine.pm) perl(Text/SpanningTable.pm) perl(Text/Wrapper.pm) perl(URI/Escape.pm) perl(XML/LibXML.pm) perl(XML/RSS.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 4.07
Release: alt1
Summary: a Gemini-based wiki
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SC/SCHROEDER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module contains the core of the Phoebe wiki. Import functions and variables
from this module to write extensions, or to run it some other way. Usually,
script/phoebe is used to start a Phoebe server. This is why all the
documentation regarding server startup can be found there.

This section describes some hooks you can use to customize your wiki using the
config file, or using a Perl file (ending in *.pl or *.pm) in the
conf.d directory. Once you're happy with the changes you've made, restart the
server, or send a SIGHUP if you know the PID.

Here are the ways you can hook into Phoebe code:

`@extensions' is a list of code references allowing you to handle additional
URLs; return 1 if you handle a URL; each code reference gets called with $stream
(the Mojo::IOLoop::Stream manpage), the first line of the request (a Gemini URL, a Gopher
selector, a finger user, a HTTP request line), a hash reference for the headers
(in the case of HTTP requests), and a buffer of bytes (e.g. for Titan or HTTP
PUT or POST requests).

`@main_menu' adds more lines to the main menu, possibly links that aren't
simply links to existing pages.

`@footer' is a list of code references allowing you to add things like licenses
or contact information to every page; each code reference gets called with
$stream (the Mojo::IOLoop::Stream manpage), $host, $space, $id, $revision, and $format
('gemini' or 'html') used to serve the page; return a gemtext string to append
at the end; the alternative is to overwrite the `footer' or `html_footer' subs
.e' the default implementation for Gemini adds History, Raw text and HTML link,
and `@footer' to the bottom of every page; the default implementation for HTTP
just adds `@footer' to the bottom of every page.

If you do hook into Phoebe's code, you probably want to make use of the
following variables:

`$server' stores the command line options provided by the user.

`$log' is how you log things.

A very simple example to add a contact mail at the bottom of every page; this
works for both Gemini...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CONTRIBUTING.md README.md Changes
%_man1dir/*
%perl_vendor_privlib/A*
%_bindir/*

%changelog
