# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Prove.pm) perl(Cache/FastMmap.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(Module/Build/Tiny.pm) perl(POSIX/AtFork.pm) perl(Redis.pm) perl(Test/Harness.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name App-Prove-Plugin-MultipleConfig
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: set multiple configs for parallel prove tests
Group: Development/Perl
License: perl
URL: https://github.com/YamadaTakahito/App-Prove-Plugin-MultipleConfig

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TA/TAKAHITO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
App::Prove::Plugin::MultipleConfig is the prove manpage plugin for setting multiple configs for parallel test.

This plugin enables you to change each environment for each test.
For example, if you want to use some databases and redis when testing, each test can use a different database and redis.

First, you make config files, the number of files is -j(the number of jobs).
Each test reads this config file like `do $config_path;'.

    # ./config/config1.pl
    my $config = +{
        'DB' => {
            uri => 'DBI:mysql:database=test_db;hostname=127.0.0.1;port=10002',
            username => 'root',
            password => 'root',
        },
        'REDIS' => +{
            server => '127.0.0.1:20003',
        },
    };

    $config;

Next, you make a module for initializing tests. This method is called once every config before starting tests.
This module must have a `prepare' method whose second argument is a config path.

    # t/Prepare.pm
    sub prepare {
        my ($self, $config) = @_;
        my $conf = do $config;

        my $uri = $conf->{DB}->{uri};
        $uri =~ s/database=.+?;/database=mysql;/; # use mysql table
        my $dbh = DBI->connect($uri, $conf->{DB}->{username}, $conf->{DB}->{password},
            {'RaiseError' => 1}
        );
        ....
    }

In the end, you pass arguments to prove for specifying prepare module and config files paths.
This format is comma-separated value(CSV). First value is prepared module name. Subsequent values are config files path.

 prove -j3 -PMySQLPool t::Prepare,./config/config1.pl,./config/config2.pl,./config/config3.pl

Congratulations! In each test, you can read `ENV{PERL_MULTIPLE_CONFIG}' which returns a config path.

    # your test code
    my $config_path = $ENV{PERL_MULTIPLE_CONFIG};
    my $conf = do $config_path;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/A*
%perl_vendor_privlib/C*
%perl_vendor_privlib/T*

%changelog
