# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Prove.pm) perl(Carp.pm) perl(Class/Method/Modifiers.pm) perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(String/Format.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(YAML/PP.pm) perl(lib.pm) perl(strict.pm) perl(subs.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name App-Prove-Plugin-TestArgs
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.1.1
Release: alt1
Summary: A prove plugin to configure test aliases and arguments
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SV/SVW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the TAP::Harness manpage is the default test harness of the `prove' command-line test
driver program. The harness has a `test_args' object attribute that allows us
to pass different arguments to test scripts. Furthermore the harness
`runtests()' object method implementation helps us to run a test script
multiple times giving each run a unique test name (an `alias').  Unfortunately
it seems to be impossible to control this feature directly via the `prove'
command-line interface. `prove' uses the full path to the test script as the
test name in its test output.

This plugin allows us to assign multiple `alias'-`args' mappings to a test
script.  Each mapping triggers a separate run of the test script. The `args'
key of a mapping is optional. If it is missing, `prove''s own optional test
script arguments, passed at the command-line after an arisdottle (`::'), are
used as a default.

For the time being the configuration has to be stored in a YAML file that is
the only argument passed to this plugin.

`prove''s test output no longer shows the test script names, if test aliases
are configured. As of version `2.1.0' this plugin provides an alternative
configuration scheme that helps us to overcome this drawback.

  # t/config_name_scripts.yml
  ---
  name: "%%s (%%a)"
  scripts:
    t/foo.t:
      - alias: "foo once"
        args:  [ABC, DEF]
      - alias: "foo twice"
      - alias: "foo thrice"
        args:  [GHI]

  # command-line 
  prove -PTestArgs=t/config_name_scripts.yml --verbose t/foo.t t/bar.t :: UVW XYZ
  t/foo.t (foo once) ....
  1..1
  # ['ABC','DEF']
  ok 1 - t/foo.t
  ok
  t/foo.t (foo twice) ...
  1..1
  # ['UVW','XYZ']
  ok 1 - t/foo.t
  ok
  t/foo.t (foo thrice) ..
  1..1
  # ['GHI']
  ok 1 - t/foo.t
  ok
  t/bar.t ...............
  1..1
  # ['UVW','XYZ']
  ok 1 - t/bar.t
  ok
  All tests successful.
  Files=4, Tests=4,  0 wallclock secs ( 0.02 usr  0.01 sys +  0.15 cusr  0.02 csys =  0.20 CPU)
  Result: PASS

The `scripts' key points to the test scripts mapping. The `name' key points
to a sprin...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%changelog
