%define module_name App-Rangeops
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AlignDB/IntSpan.pm) perl(App/Cmd.pm) perl(App/Fasops.pm) perl(App/RL.pm) perl(Graph.pm) perl(IPC/Cmd.pm) perl(List/MoreUtils.pm) perl(MCE.pm) perl(Module/Build/Tiny.pm) perl(Path/Tiny.pm) perl(Test/More.pm) perl(YAML/Syck.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.1
Release: alt1
Summary: operates ranges and links of ranges on chromosomes
Group: Development/Perl
License: perl
URL: https://github.com/wang-q/App-Rangeops

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WA/WANGQ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Types of links:

=over 8

=item Bilateral links

    I(+):13063-17220_I(-):215091-219225
    I(+):139501-141431_XII(+):95564-97485

=item Bilateral links with hit strand

    I(+):13327-17227_I(+):215084-218967_-
    I(+):139501-141431_XII(+):95564-97485_+

=item Multilateral links

    II(+):186984-190356_IX(+):12652-16010_X(+):12635-15993

=item Merge files aren't links

    I(-):13327-17227_I(+):13327-17227

=back

Steps:

    sort
      |
      v
    clean -> merge
      |     /
      |  /
      v
    clean
      |
      V
    connect
      |
      v
    filter


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/A*
%_man1dir/*
%_bindir/*

%changelog
