%define module_name App-Sandy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Data/Inheritable.pm) perl(Compress/BGZF/Writer.pm) perl(DBD/SQLite.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(Data/OptList.pm) perl(Dist/Zilla/Plugin/MakeMaker/Awesome.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Cat.pm) perl(File/Path.pm) perl(File/ShareDir/Install.pm) perl(Getopt/Long.pm) perl(Hook/AfterRuntime.pm) perl(IO/Compress/Gzip.pm) perl(IO/Handle.pm) perl(IO/Uncompress/Gunzip.pm) perl(Import/Into.pm) perl(List/Util.pm) perl(Math/Random.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/Singleton.pm) perl(MooseX/StrictConstructor.pm) perl(MooseX/UndefTolerant.pm) perl(Parallel/ForkManager.pm) perl(Path/Class.pm) perl(PerlIO/gzip.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Storable.pm)
BuildRequires: perl(Test/Class.pm) perl(Test/Most.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/UseAllModules.pm) perl(Text/ASCIITable.pm) perl(Try/Tiny.pm) perl(autodie.pm) perl(base.pm) perl(constant.pm) perl(feature.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(true.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23
Release: alt1
Summary: A straightforward and complete next-generation sequencing read simulator
Group: Development/Perl
License: gpl
URL: https://galantelab.github.io/sandy/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TM/TMILLER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Sandy is a bioinformatic tool that provides a simple engine to generate
single-end/paired-end reads from a given fasta file. Many next-generation sequencing
(NGS) analyses rely on hypothetical models and principles that are not precisely
satisfied in practice. Simulated data, which provides positive controls would be a
perfect way to overcome these difficulties. Nevertheless, most of NGS simulators are
extremely complex to use, they do not cover all kinds of the desired features needed
by the users, and (some) are very slow to run in a standard computer. Here, we present
Sandy, a straightforward, easy to use, fast, complete set of tools to generate synthetic
next-generation sequencing reads. Sandy simulates whole genome sequencing, whole exome
sequencing, RNAseq reads and it presents several features to the users manipulate the data.
Sandy can be used therefore for benchmarking results of a variety of pipelines in the
genomics or trancriptomics.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/A*
%perl_vendor_privlib/auto/*
%_man1dir/*
/usr/share/bash-completion/completions/sandy
/usr/share/zsh/site-functions/_sandy
%_bindir/*

%changelog
