# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/SimpleScan.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Test/Differences.pm) perl(Test/More.pm) perl(Test/WWW/Simple.pm) perl(Text/Balanced.pm)
# END SourceDeps(oneline)
%define module_version 1.03
%define module_name App-SimpleScan-Plugin-LinkCheck
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Link counting/presence/absence plugin 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MC/MCMAHON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Th Linkcheck plugin adds simple link counting and presence/absence
checking pragmas to `simple_scan'. These pragmas are assertions;
they will be run for every test spec occurring after the pragma(s)
appear in the intput file.

You can, for instance, assert that you do not want to see a link
named 'Click here' anywhere in the pages referenced by the test
specs in this test:

  %%%%no_link 'Click here' 

Additional test specs generated by variable substitution will
each have the check made, so for example

  %%%%which bar baz quux
  http://<which>.foo.com  /foo.com/ Y   Fetch page

would check for /foo.com/ on each of bar.foo.com, 
baz.foo.com, and quux.foo.com, and also check for zero links
whose name is 'Click here' on each of these pages.

Conversely, you can assert that a link must be present on
each page you look at:

  %%%%has_link 'back'

This means that a link named 'back' must appear on every page
you fetch after this pragma occurs in the input.

You may want to remove the condition for some pages in your
tests; this can easily be done by 'forgetting' the link:

  %%%%forget_link 'back'

The assertion has now been dropped, and will not be tested
through the rest of the file. If you want to forget all of
the currently-active link-count assertions, just use

  %%%%forget_all_links

and all of the link checks will stop.

If you want to be more specific about the link counts, 
you can use the extended syntax for '%%%%has_link':

  %%%%has_link 'beta' >= 0
  %%%%has_link 'up' == 2
  %%%%has_link 'report_problems' != 1

Note that you can use any of the *numeric* operators and
a count for this. These work just like the other tests, in
that they apply to every test spec following until either
the end of the file, or a '%%%%forget_link' that drops them.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
