%define module_name App-Spoor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Date/Format.pm) perl(DateTime.pm) perl(DateTime/Format/Strptime.pm) perl(File/Tail.pm) perl(File/Touch.pm) perl(JSON.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(PHP/HTTPBuildQuery.pm) perl(Path/Tiny.pm) perl(Sys/Hostname.pm) perl(Term/ANSIColor.pm) perl(Test/LWP/UserAgent.pm) perl(Test/MockTime.pm) perl(Test/More.pm) perl(Test/SetupTeardown.pm) perl(Text/CSV.pm) perl(URI/Escape.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: A CPanel client for the Spoor service
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RO/RORYMCK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module (for now) only contains code to provide a naive implementation of a client for the
Spoor API that plays nicely with CPanel.

It is built with the following principles in mind:

=over

=item * Minimise the impact of the code on the existing CPanel instance

=item * Minimise the footprint on the host, by keeping the dependencies to a bare minimum

=item * Be as transparent as possible about the data that is being submitted

=back

Within the above context, App::Spoor consists of 3 main parts:

=over

=item * Scripts running under systemd that tail the CPanel access, error and login logs

=item * A transmitter script (also running under systemd) that communicates with the Spoor API

=item * A module that registers functionality for tracking changes to mail forwarding within the CPanel standardised hook framework

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*
%_bindir/*

%changelog
