%define module_version 1.000
%define module_name App-Statsbot
BuildRequires: perl-podlators
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(IRC/Utils.pm) perl(POE.pm) perl(POE/Component/IRC/State.pm) perl(Test/Perl/Critic.pm) perl(Text/ParseWords.pm) perl(Time/Duration.pm) perl(Time/Duration/Parse.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt1
Summary: simple IRC bot that tracks time spent in a channel
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
App::Statsbot is a simple IRC bot that tracks the people that inhabit
a channel. It is able to answer queries of the form "In the last <time
interval>, how much time did <nick> spend in this channel?".

It is configured via global variables in the App::Statsbot package.

=over

=item $DEBUG

If true, print some debug information. Defaults to false.

=item $TICK

How often (in seconds) to poll the channel for nicks. Defaults to 10
seconds.

=item $NICKNAME

The nickname of the bot. Defaults to "statsbot".

=item $SERVER

The IRC server. Defaults to "irc.freenode.net".

=item $PORT

The port. Defaults to 6667.

=item $SSL

If true, connect via SSL. Defaults to false.

=item @CHANNELS

Array of channels to connect to. Defaults to an empty array, which is
not very useful.

=item $DB

Path to SQLite database. Must be writable. Will be created if it does
not exist. Defaults to `/var/lib/statsbot/db'.

=back

After configuration, the bot can be started using the run function,
which can be called as either a regular function or a method.

%package scripts
Summary: %name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %name

%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*
%_man1dir/*


%changelog
