%define module_name App-Task
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/Interactive/Tiny.pm) perl(IPC/Open3/Utils.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Test/Trap.pm) perl(Text/OutputFilter.pm) perl(Tie/Handle/Base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Nest tasks w/ indented output and pre/post headers
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DM/DMUEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This allows us to create scripts that organize tasks together and have their output be organized similarly and with added clarity.

It does this by wrapping each task in a starting/ending output line, indenting output congruent with nested `task()' depth.

For example, say this:

    system(.eI);
    foo();
    system(.eI,.eI);
    say test_foo() ? "foo is good" : "foo is down";
 
outputs this:

    Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
    Nunc mi ipsum faucibus vitae aliquet nec ullamcorper sit amet.
    Facilisi morbi tempus iaculis urna id volutpat lacus laoreet.
    Ullamcorper eget nulla facilisi etiam dignissim diam.
    Maecenas volutpat blandit aliquam etiam erat velit scelerisque in dictum.
    foo is good

Nothing wrong with that but it could be easier to process visually, so if we `task()'.e'd it up a bit like this:

    task "setup foo" => sub {
        task "configure foo" => ".eI";
        task "run foo" => \&foo;
    };

    task "finalize foo" => sub {
        task "enable barring" => [.eI,.eI];
        task "verify foo" => sub {
            say test_foo() ? "foo is good" : "foo is down";
        };
    };

Now you get:

    .''.''.''.'' [1.1] setup foo .eI
        .''.''.''.'' [2.1] configure foo .eI
            Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
         .eI done (configure foo).

        .''.''.''.'' [2.2] run foo .eI
            Nunc mi ipsum faucibus vitae aliquet nec ullamcorper sit amet.
            Facilisi morbi tempus iaculis urna id volutpat lacus laoreet.
         .eI done (run foo).

     .eI done (setup foo).

    .''.''.''.'' [1.2] finalize foo .eI
        .''.''.''.'' [2.1] enable barring .eI
            Ullamcorper eget nulla facilisi etiam dignissim diam.
            Maecenas volutpat blandit aliquam etiam erat velit scelerisque in dictum.
         .eI done (enable barring).

        .''.''.''.'' [2...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
