%define module_name App-lcpan-CmdBundle-cpanlists
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/lcpan.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.020
Release: alt1
Summary: lcpan subcommands related to Acme::CPANLists
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/App-lcpan-CmdBundle-cpanlists

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution packages several lcpan subcommands related to
the Acme::CPANLists manpage. More subcommands will be added in future releases.

Some ideas:

cpanlists-stats. Number of modules. But we will want to also know the number
of lists, total number of entries, average number of entries per list, average
number of lists per modules.

Perhaps an indexing hook could be added, so that lcpan indexes the lists
themselves? To be safer, an Acme::CPANLists module could export the lists to a
JSON, so lcpan does not have to load the module.

The indexing part could be modularized, so we can have a SQLite database
containing list information without having to have lcpan, because lcpan database
is huge.

Or (easier)... lcpan could just call this indexer. The cpanlists indexer indexes
to a separate SQLite database. But note that the cpanlists indexer *will*
eval/load the modules.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/A*

%changelog
