# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/optex.pm) perl(Encode.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name App-optex-mask
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: optex data masking module
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/optex-mask

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
App::optex::mask is an optex module for masking data given as
standard input to a command to be executed. It transforms strings
matching a specified pattern according to a set of rules before giving
them as input to a command, and restores the resulting content to the
original string.

Multiple conversion rules can be specified, but currently only `xml'
is supported.  This is for deepl translation interface, and
converts a string to an XML tag such as `<m id=999 />'.

The following example translates an English sentence into French.

    $ echo All men are created equal | deepl text --to FR "$(cat)"
    Tous les hommes sont cra.a.s a.gaux

If you want to leave part of a sentence untranslated, specify a
pattern that matches the string.

    $ echo All men are created equal | \
        optex -Mmask::set=debug men -- sh -c 'deepl text --to FR "$(cat)"'
    [1] All men are created equal
    [2] All <m id=1 /> are created equal
    [3] Tous les <m id=1 /> sont cra.a.s a.gaux
    [4] Tous les men sont cra.a.s a.gaux
    Tous les men sont cra.a.s a.gaux

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/A*

%changelog
