%define module_name App-optex-msdoc
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Greple.pm) perl(App/Greple/msdoc.pm) perl(App/optex.pm) perl(Encode.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: module to replace MS document by its text contents
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/optex-msdoc

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module replaces argument which terminate with *.docx*, *pptx*
or *xlsx* files by node representing its text information.  File
itself is not altered.

For example, you can check the text difference between MS word files
like this:

    $ optex diff -Mmsdoc OLD.docx NEW.docx

If you have symbolic link named diff to optex, and following
setting in your ~/.optex.d/diff.rc:

    option default --msdoc
    option --msdoc -Mmsdoc $<move>

Next command simply produces the same result.

    $ diff OLD.docx NEW.docx

Text data is extracted by greple command with -Mmsdoc module,
and above command is almost equivalent to below bash command using
process substitution.

    $ diff <(greple -Mmsdoc --dump OLD.docx) \
           <(greple -Mmsdoc --dump NEW.docx)

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/A*

%changelog
