# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Module/Build/Tiny.pm) perl(Pod/Find.pm) perl(Pod/Usage.pm) perl(Test/Differences.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name App-pathed
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: munge the Bash PATH environment variable
Group: Development/Perl
License: perl
URL: https://github.com/marcelgruenauer/pathed

Source0: http://cpan.org.ua/authors/id/M/MA/MARCEL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The Bash `PATH' environment variable contains a colon-separated list of paths.
Platforms other than UNIX might use a different separator; `pathed' uses the
default separator for the current OS. `pathed' - "path editor" - can split
the path, append, prepend or remove elements, remove duplicates and reassemble
it.

The result is then printed so you can assign it to the `PATH' variable. If
`--split' is used, each path element is printed on a separate line, so you can
iterate over them, for example.

The path elements can also be checked with `--check' to make sure that the
indicated paths are readable.

But `pathed' isn't just for the `PATH' variable. You can specify an
environment variable to use with the `--var' option, or just pass a value to
be used directly after the options.

The following command-line options are supported:

=over 4

=item `--append', `-a' `<path>'

Appends the given path to the list of path elements. This option can be
specified several times; the paths are appended in the given order.

=item `--prepend', `-p' `<path>'

Prepends the given path to the list of path elements. This option can be
specified several times; the paths are prepended in the given order. For
example:

    $ pathed -p first -p second -p third

will result in `third:second:first:$PATH'.

=item `--delete', `-d' `<substr>'

Deletes those path elements which contain the given substring. This option can
be specified several times; the path elements are deleted in the given order.

When options are mixed, `--append' is processed first, then `--prepend', then
`--delete'.

=item `--unique', `-u'

Removes duplicate path elements.

=item `--split', `-s'

Prints each path element on its own line. If this option is not specified, the
path elements are printed on one line, joined by the default path separator as
reported by the Config manpage - usually a colon -, like you would normally specify the
`PATH' variable.

=item `--check', `-c'

Checks whether each path element is readable and prints warnings if necessary.
Does not check whether the path element is a directory because `pathed' can
also be used for specifying multiple files such as configuration files.
Warnings are printed only once per path element, even if that element occurs
several times in `PATH'.

When `--check' is used, the path is not printed. `--check' and `--split' are
mutually exclusive.

=item `--var', `-v' `<variable>'

Use the indicated environment variable.

=item `--sep', `-e' `<separator>'

The default path separator is what the Config manpage reports - usually a colon - but
with this option you can specify a different separator. It is used to split the
input path and to join the output path.

=item `--help', `-h'

Prints the synopsis.

=item `--man'

Prints the whole documentation.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
