%define module_version 0.17
%define module_name App-sibs
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Test/More.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: Simple incremental backup system
Group: Development/Perl
License: artistic_2
URL: https://github.com/jhthorsen/app-sibs

Source0: http://cpan.org.ua/authors/id/J/JH/JHTHORSEN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`sibs' create backup from your computer to a destination server, using
`rsync'.

=over 4

=item * Setup

First you need to `setup' sibs. The setup process will create a SSH key
which is uploaded to the `destination' server. The key is created using
`ssh-keygen' and uploaded using `ssh' and `perl'.

In addition, this step will create or update a config file. The default
config file is the section on ".sibs.conf" in the $HOME manpage, but you can also specify your own path.

=item * Backup

The second step will create the actual backup. This step can be automated
in a cronjob, because the key created in the first step will not require
any password to log into the remote backup server. Example crontab:

  0 */4 * * * /usr/local/bin/sibs backup 2>/dev/null 1>/dev/null

This will create a backup every four hours. The backup will be "full" each
time and kept for a month. Even so, it probably won't take up too much space,
since all the files are hard linked, meaning an unchanged file will take up
the same disk space for each backup.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README.pod Changes README
%perl_vendor_privlib/A*

%files scripts
%_bindir/*

%changelog
