Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Parser.pm) perl(YAML/Tiny.pm) perl(parent.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-Archive-RPM
Version:    0.07
Release:    alt2_36
Summary:    Work with a RPM
# lib/Archive/RPM.pm -> LGPL-2.1-or-later
# lib/Archive/RPM/ChangeLogEntry.pm -> LGPL-2.1-or-later
License:    LGPL-2.1-or-later
Url:        https://metacpan.org/release/Archive-RPM
Source:     https://cpan.metacpan.org/authors/id/R/RS/RSRCHBOY/Archive-RPM-%{version}.tar.gz
# Restore compatibility with Moose > 2.1005, bug #1168859, CPAN RT#100701
Patch0:     Archive-RPM-0.07-Inject-RPM2-Headers-into-INC-for-Moose-2.1005.patch
# Adjust method delegation filter to Moose-2.1900, bug #1420330, CPAN RT#120270
Patch1:     Archive-RPM-0.07-Adjust-to-Moose-2.1900.patch
BuildArch:  noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/AutoInstall.pm)
BuildRequires:  perl(Module/Install/External.pm)
# Module::Install::ExtraTests not helpful
BuildRequires:  perl(Module/Install/GithubMeta.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/ReadmeFromPod.pm)
BuildRequires:  perl(Module/Install/ReadmeMarkdownFromPod.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  cpio
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(MooseX/AttributeHelpers.pm)
BuildRequires:  perl(MooseX/MarkAsMethods.pm)
BuildRequires:  perl(MooseX/Traits.pm)
BuildRequires:  perl(MooseX/Types/DateTimeX.pm)
BuildRequires:  perl(MooseX/Types/Path/Class.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(Path/Class.pm)
BuildRequires:  perl(RPM2.pm)
# Tests:
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(warnings.pm)
Requires:       cpio
Requires:       perl(MooseX/Traits.pm)
Obsoletes:      perl-Archive-RPM-tests < 0.07-9


Source44: import.info

%description
Archive::RPM provides a more complete method of accessing an RPM's meta-
and actual data. We access this information by leveraging RPM2 where we
can, and by "exploding" the rpm with rpm2cpio and cpio when we need
information we can't get through RPM2.

%prep
%setup -q -n Archive-RPM-%{version}
%patch0 -p1
%patch1 -p1
# Remove bundled modules
rm -r ./inc
sed -i -e '/^inc\//d' MANIFEST
# Remove useless dependency, CPAN RT#100703
sed -i -e "/^requires 'MooseX::Types::DateTime';\$/d" Makefile.PL
# Disable authors tests
sed -i -e '/^extra_tests;$/d' Makefile.PL

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
