%define module_version 1.10
%define module_name Array-Heap-ModifiablePriorityQueue
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Array/Heap.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.10
Release: alt1
Summary: Modifiable priority queue using Array::Heap
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BO/BOBMATH/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module implements a priority queue, which is a data structure that can
efficiently locate the item with the lowest weight at any time. This is useful
for writing cost-minimizing and shortest-path algorithms.

Why another priority queue module? First, unlike many similar modules, this one
allows you to modify the queue. Items can be removed from the queue or have
their weight changed after they are added.

Second, it simple to use. Items in the queue don't have to implement any
specific interface. Just throw them in there along with a weight value and
the module will keep track of everything.

Finally, it has good performance on large datasets. This is because it is
based on a partially-ordered heap data structure. Many other priority
queue modules are based on fully sorted lists (even ones that claim to be
heaps). Keeping the items only partially sorted saves time when there are
are a large number of them (several thousand or so).

This module is a Perl wrapper around the Array::Heap manpage, a lightweight and fast
heap management module implemented in XS.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes Todo README
%perl_vendor_privlib/A*

%changelog
