%define module_version 0.0.9
%define module_name Array-To-Moose
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Array/GroupBy.pm) perl(Carp.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/StrictConstructor.pm) perl(Params/Validate/Array.pm) perl(Test/More.pm) perl(base.pm) perl(namespace/autoclean.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.9
Release: alt1
Summary: Build Moose objects from a data array
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SAMB/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
As shown in the above examples, the general usage is:

  package MyClass;
  use Moose;
  (define Moose object(s))
  ...
  use Array::To::Moose;
  ...
  my $data_ref = selectall_arrayref($sql); # for example

  my $object_ref =  array_to_moose(
                        data => $data_ref
                        desc => {
                          class    => 'MyClass',
                          key      => K,   # only for HashRefs
                          attrib_1 => N1,
                          attrib_2 => N2,
                          ...
                          attrib_m => [ M ],
                          ...
                          SubObject => {
                            class => 'MySubClass',
                            ...
                          }
                        }
  );

Where:

`array_to_moose()' returns an array- or hash reference of `MyClass'
Moose objects.
All Moose classes (`MyClass', `MySubClass', etc) must
already have been defined by the user.

`$data_ref' is a reference to an array containing references to arrays of
scalars of the kind returned by, e.g.,
DBI::selectall_arrayref()

`desc' (descriptor) is a reference to a hash which contains several types
of data:

`class =>' 'MyObj' is *required* and defines the Moose class or
package which will contain the data. The user should have defined this class
already.

`key => N ' is required
if the Moose object being constructed is to be a hashref, either at
the top-level Moose object returned from `array_to_moose()' or as a
"`isa => 'HashRef[...]''" sub-object.

`attrib => N ' where `attrib' is the name of a Moose attribute
("`has 'attrib' =>' ...") 

`attrib => [ N ] ' where `attrib' is the name of a Moose "simple" sub-attribute
("`has => 'attrib' ( isa => 'ArrayRef[Type]' ...)' "), where `Type'
is a "simple" Moose type, e.g., `'Str', 'Int'', etc.

In the above cases, `N' is a positive integer containing the
the corresponding zero-indexed
column number in the data array where that attribute's data is to be found.


%prep
%setup -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
