%define module_name Artifactory-Client
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(HTTP/Request.pm) perl(HTTP/Request/StreamingUpload.pm) perl(JSON/MaybeXS.pm) perl(LWP/UserAgent.pm) perl(Moose.pm) perl(MooseX/StrictConstructor.pm) perl(Path/Tiny.pm) perl(URI/Escape.pm) perl(WWW/Mechanize.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.8.0
Release: alt1
Summary: Perl client for Artifactory REST API
Group: Development/Perl
License: artistic_2
URL: https://github.com/satoshi/Artifactory-Client

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SY/SYAGI/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is a Perl client for Artifactory REST API: https://www.jfrog.com/confluence/display/RTF/Artifactory+REST+API
Every public method provided in this module returns a HTTP::Response object.

    use Artifactory::Client;

    my $args = {
        artifactory => 'http://artifactory.server.com',
        port => 8080,
        repository => 'myrepository',
        ua => LWP::UserAgent->new() # LWP::UserAgent-like object is pluggable.  Default is LWP::UserAgent.
    };

    my $client = Artifactory::Client->new( $args );
    my $path = '/foo'; # path on artifactory

    # Properties are a hashref of key-arrayref pairs.  Note that value must be an arrayref even for a single element.
    # This is to conform with Artifactory which treats property values as a list.
    my $properties = {
        one => ['two'],
        baz => ['three'],
    };
    my $content = "content of artifact";

    # Name of methods are taken straight from Artifactory REST API documentation.  'Deploy Artifact' would map to
    # deploy_artifact method, like below.  The caller gets HTTP::Response object back.
    my $resp = $client->deploy_artifact( path => $path, properties => $properties, content => $content );

    # Custom requests can also be made via usual get / post / put / delete requests.
    my $resp = $client->get( 'http://artifactory.server.com/path/to/resource' );


%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/A*

%changelog
