# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Asterisk-CDR
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl extension for accessing Asterisk CDRs stored in a database as objects
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JB/JBODNAR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Asterisk::CDR is a Perl module for accessing Asterisk CDRs stored in a dabatase as objects. It inherits all but one of its useful methods from Class::DBI.

Database information is supplied as a list to the init_db() class method. A DBI data source string, username and password must be supplied. By default, Asterisk::CDR will use cdr as the table and the standard columns expected by Asterisk's cdr_odbc module. Both the table name and the columns can be overriden by specifiying them when calling init_db():

 use Asterisk::CDR;
 Asterisk::CDR->init_db (
                         dsn => 'dbi:mysql:database',
                         username => 'username',
                         password => 'password',
                         table => 'my_cdrs',
                         columns => \@my_columns
                        );

After init_db() is called, Class::DBI methods may be called to retrieve CDRs as objects:

 my @cdrs = Asterisk::CDR->retrieve(src => '5555551212'); # Retrieve CDRs originating from 555-555-1212


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
