%define module_name Astro-Coord-ECI-VSOP87D
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Astro/Coord/ECI.pm) perl(Astro/Coord/ECI/Mixin.pm) perl(Astro/Coord/ECI/Sun.pm) perl(Astro/Coord/ECI/Utils.pm) perl(CPAN/Meta.pm) perl(Carp.pm) perl(Config.pm) perl(Data/Dump.pm) perl(Exporter.pm) perl(File/Basename.pm) perl(File/Glob.pm) perl(Module/Build.pm) perl(Module/Metadata.pm) perl(POSIX.pm) perl(Pod/Usage.pm) perl(Storable.pm) perl(Test/More.pm) perl(Time/Local.pm) perl(base.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.007
Release: alt1
Summary: Implement the VSOP87D position model.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WY/WYANT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This Perl module implements the VSOP87D model of planetary motion in a
manner that is consistent with the
Astro::Coord::ECI hierarchy.

The VSOP87 models calculate the positions of the planets through Neptune
as a series of cosine terms. They were created by Pierre Bretagnon and
Gerard Francou of the Bureau des Longitudes in Paris France. Depending
on the model you select, you can calculate either instantaneous orbital
parameters, Heliocentric ecliptic position in either spherical or
Cartesian coordinates and either current or J2000.0 equinox, or
barycentric ecliptic position.

The models are stated to be within 1 second of arc for varying times
around J2000 (about noon January 1 2000 UT), as follows:

 4000 years for Mercury, Venus, Earth-Moon barycenter, Mars
 2000 years for Jupiter and Saturn
 6000 years for Uranus and Neptune

The actual model coefficients are available from
http://cdsarc.u-strasbg.fr/viz-bin/qcat?VI/81/, as is additional
information the accuracy of the model, and a reference implementation in
Fortran.

VSOP87D provides Heliocentric spherical coordinates referred to the
current equinox. This is consistent with the existing members of the
Astro::Coord::ECI hierarchy, but more importantly
Jean Meeus' Astronomical Algorithms provides worked examples for the Sun
and Venus.

The VSOP87D model itself is simple enough to implement, and occupies
about 50 lines of Perl. Testing shows that the Perl solution for a given
body and time is within `5e-9' of the Fortran reference implementation
over selected years in the range -4000 to 2300. The units of that
`5e-9' vary, being radians for longitude and latitude, AU for radius,
and radians/day and AU/day for the corresponding velocities.

One of the advantages of the VSOP87 models over the previous VSOP82
models is that they are easily truncated when less than full precision
is required. Meeus has his own truncation, which is the default one. In
addition, this code provides truncation `'none'', which uses the whole
model, and a mechanism to define cu...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
