%def_without test
%define module_name Astro-Sunrise
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/Trig.pm) perl(POSIX.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.99
Release: alt1
Summary: Perl extension for computing the sunrise/sunset on a given day
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JF/JFORGET/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module will return the sunrise/sunset for a given day.

Months are numbered 1 to 12, in the usual way, not 0 to 11 as in
C and in Perl's localtime.

 Eastern longitude is entered as a positive number
 Western longitude is entered as a negative number
 Northern latitude is entered as a positive number
 Southern latitude is entered as a negative number

Please note that the longitude is specified before the latitude.

The time zone is given as the numeric value of the offset from UTC.
 
inter is set to either 0 or 1.
If set to 0 no Iteration will occur.
If set to 1 Iteration will occur.
Default is 0.

There are a number of sun altitudes to chose from.  The default is
-0.833 because this is what most countries use. Feel free to
specify it if you need to. Here is the list of values to specify
altitude (ALT) with, including symbolic constants for each.

=over

=item 0 degrees

Center of Sun's disk touches a mathematical horizon

=item -0.25 degrees

Sun's upper limb touches a mathematical horizon

=item -0.583 degrees

Center of Sun's disk touches the horizon; atmospheric refraction accounted for

=item -0.833 degrees, DEFAULT

Sun's upper limb touches the horizon; atmospheric refraction accounted for

=item -6 degrees, CIVIL

Civil twilight (one can no longer read outside without artificial illumination)

=item -12 degrees, NAUTICAL

Nautical twilight (navigation using a sea horizon no longer possible)

=item -15 degrees, AMATEUR

Amateur astronomical twilight (the sky is dark enough for most astronomical observations)

=item -18 degrees, ASTRONOMICAL

Astronomical twilight (the sky is completely dark)

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING Changes README LICENSE doc
%perl_vendor_privlib/A*

%changelog
