%define module_name Astro-satpass
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Astro/Coord/ECI/TLE/Iridium.pm) perl(Astro/SpaceTrack.pm) perl(Browser/Open.pm) perl(CPAN/Meta.pm) perl(Carp.pm) perl(Clone.pm) perl(Config.pm) perl(Data/Dumper.pm) perl(Date/Manip.pm) perl(Exporter.pm) perl(File/HomeDir.pm) perl(FileHandle.pm) perl(Getopt/Std.pm) perl(HTML/TreeBuilder.pm) perl(HTTP/Date.pm) perl(IO/File.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Module/Metadata.pm) perl(POSIX.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Term/ReadLine.pm) perl(Test/MockTime.pm) perl(Test/More.pm) perl(Time/Local.pm) perl(Time/y2038.pm) perl(YAML.pm) perl(base.pm) perl(constant.pm) perl(if.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.132
Release: alt1
Summary: Classes and app to compute satellite visibility
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WY/WYANT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module was written to provide a base class for a system to predict
satellite visibility. Its main task is to convert the
Earth-Centered Inertial (ECI) coordinates generated by the NORAD models
into other coordinate systems (e.g. latitude, longitude, and altitude
above mean sea level), but a other functions have accreted to it.
In addition, a few support routines have been exposed for testing, or
whatever.

All distances are in kilometers, and all angles are in radians
(including right ascension, which is usually measured in hours).

Times are normal Perl times, whether used as universal or dynamical
time. Universal time is what is usually meant, unless otherwise stated.

Known subclasses include Astro::Coord::ECI::Moon to predict the
position of the Moon, Astro::Coord::ECI::Star to predict the
position of a star, or anything else that can be considered fixed on
the celestial sphere, Astro::Coord::ECI::Sun to predict the position
of the Sun, Astro::Coord::ECI::TLE to predict the position of a
satellite given the NORAD orbital parameters, and
Astro::Coord::ECI::TLE::Iridium (a subclass of
Astro::Coord::ECI::TLE) to predict Iridium flares.

Note that in version 0.022_01 the velocity code got a substantial
rework, which is still in progress. I am attempting give useful
velocities where they are available, and no velocities at all where they
are not.  Unfortunately I have yet to locate any worked problems, so the
velocity code is, in the most literal sense, untested.

In general, locations specified in Earth-fixed coordinates are
considered to share the rotational velocity of the Earth, and locations
specified in inertial coordinates are considered to have undefined
velocities unless a velocity was specified explicitly or produced by the
object's model. This involved a change in the behavior of the eci()
method when velocity was not specified but location was. See the next
paragraph for my excuse.

Caveat user: This class and its subclasses should probably be
considered alpha code, meaning that the public interface may not be
completely stable. I will try not to change it, but given sufficient
reason I will do so. If I do so, I will draw attention to the change
in the documentation.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.MacOS Changes README CONTRIBUTING
%perl_vendor_privlib/A*

%changelog
