%define module_name Async-Defer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AE.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.1
Release: alt1
Summary: VM to write and run async code in usual sync-like way
Group: Development/Perl
License: mit
URL: https://github.com/powerman/perl-Async-Defer

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
WARNING: This is experimental code, public interface may change..
This module's goal is to simplify writing complex async event-based code,
which usually mean huge amount of callback/errback functions, very hard to
support. It was initially inspired by Python/Twisted's
Deferred
object, but go further and provide virtual machine which allow you to
write/define complete async program (which consists of many
callback/errback) in sync way, just like you write usual non-async
programs.

Main idea is simple. For example, if you've this non-async code:

    $var = fetch_val();
    process_val( $var );

and want to make `fetch_val()' async, you usually do something like this:

    fetch_val( cb => \&value_fetched );
    sub value_fetched {
        my ($var) = @_;
        process_val( $var );
    }

With Async::Defer you will split initial non-async code in sync parts (usually
this mean - split on assignment operator):

    ### 1
           fetch_val();
    ### 2
    $var =
    process_val( $var );

then wrap each part in separate anon sub and add Defer object to join
these parts together:

    $d = Async::Defer->new();
    $d->do(sub{
        my ($d) = @_;
        fetch_val( $d );    # will call $d->done('.eIresult.eI') when done
    });
    $d->do(sub{
        my ($d, $var) = @_;
        process_val( $var );
        $d->done();         # this sub is sync, it call done() immediately
    });
    $d->run();

These anon subs are similar to *statements* in perl. Between these
*statements* you can use *flow control* operators like `if()',
`while()' and `try()'/`catch()'. And inside *statements* you can
control execution flow using `done()', `throw()', `continue()'
and `break()' operators when current async function will finish and
will be ready to go to the continue step.
Finally, you can use Async::Defer object to keep your *local variables* -
this object is empty hash, and you can create any keys in it.
Single Defer object described this way is sort of single *function*.
And it's possible to *call* another functions by using another Defer
object as parameter for `do()' instead of usual anon sub.

While you can use both sync and async sub in `do()', they all MUST
call one of `done()', `throw()', `continue()' or `break()' when they finish
their work, and do this ONLY ONCE. This is Defer's way to proceed from
one step to another, and if not done right Defer object's behaviour is
undefined!



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/A*

%changelog
