%define module_name Atto
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(JSON/MaybeXS.pm) perl(Plack/Request.pm) perl(Plack/Test.pm) perl(Test/More.pm) perl(WWW/Form/UrlEncoded.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: A tiny microservice builder
Group: Development/Perl
License: perl
URL: https://github.com/robn/Atto

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RO/ROBN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Atto makes it trivial to create HTTP+JSON microservices out of regular Perl
code.

Adding it to your code is simple. When you `use Atto', pass it it a list of
methods (subs) in the same package that you want to make available to the
network:

    use Atto qw(hello);

Then, at the end of your program (or module!), call `Atto->psgi'. This returns a
PSGI application that can be consumed by `plackup'.

    $ plackup hello.pl 
    HTTP::Server::PSGI: Accepting connections at http://0:5000/

To call your methods from the network, send a POST request with the method
(sub) name in the URL:

    $ curl -XPOST http://localhost:5000/hello
    "hello world"

To pass arguments to the method, encode them as JSON in the request body and
add a `Content-type: application/json' header to the request:

    $ curl -XPOST -d '{"name":"dave"}' -H 'Content-type: application/json' http://localhost:5000/hello
    "hello dave"

Arguments are flattened just like in Perl, so passing a JSON array or object
will do what you expect.

Alternatively, you can pass a hash via form parameters, which is less
expressive but easier in many scenarios:

    $ curl -d 'name=dave' http://localhost:5000/hello
    "hello dave"

or with a GET and query parameters:

    $ curl http://localhost:5000/hello?name=dave
    "hello dave"

Methods should return a single value, which is then JSON-encoded for the
return. This can be a simple string or number or a hash or array ref.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README examples
%perl_vendor_privlib/A*

%changelog
