# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(Benchmark.pm) perl(CPAN.pm) perl(Cache/MemoryCache.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Attribute-Cached
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: easily cache subroutines results using a :Cached attribute
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/O/OS/OSFAMERON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
In many applications, including web apps, caching data is used to help scale
the sites, trading a slight lack of immediacy in results with a lower load on
DB and other resources.

Usually we'll do something like this

    sub my_query {
        my ($self, %%pars) = @_;
         # get a cache
        my $cache = $self->get_cache;
         # generate a key: for example with %%pars (foo=>1), we might use
         #                 the key "my_query:foo=1";
        my $key = $self->get_key( %%pars ); 
        my $result;
         # check if we've already cached this call, and return if so
        if ($result = $cache->get($key)) {
            warn "Cache hit for $key";
            return $result;
        }
         # The next lines are what this subroutine is /actually/ doing
        $result = $self->expensive_operation;
        # ... additional processing as required

         # set the result in the cache for future accesses
        $cache->set($key, $result, 20); # hard code a cache time here

        return $result;
    }

The caching logic is repeated boilerplate and, worse, really has nothing
to do with what we're trying to achieve here.  With the Attribute::Cached manpage
we'd write this as:

    sub getCache { my $self = shift; return $self->get_cache(@_) }

    sub my_query :Cached(time=>20, key=>\&get_key) {

        my $result = $self->expensive_operation;
        # ... additional processing as required

        return $result;
    }


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES
%perl_vendor_privlib/A*

%changelog
