%define module_name Attribute-Handlers-Clean
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Perlmazing.pm) perl(attributes.pm) perl(base.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: Simpler definition of attribute handlers, without messing with UNIVERSAL.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZA/ZARABOZO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is heavily based on the excellent the Attribute::Handlers manpage. Around 90%% of the code
and documentation is exactly the same. The big difference is that, while the Attribute::Handlers manpage
relies on defining things in the the UNIVERSAL manpage namespace, this module does not. Still,
this module make it easier and more intuitive to define custom attributes that will
work on your classes and subclasses.

The problem with altering the UNIVERSAL manpage is that ALL other classes loaded in Perl can
be affected by this pollution. It might even break things when their functionality
relies on basic calls like `package-'can('...')>. Still, the Attribute::Handlers manpage is
an excellent idea an implementation, but we can get away with it without polluting
the UNIVERSAL manpage by polluting only the classes using the Attribute::Handlers::Clean manpage (which
doesn't really create a problem, since putting things in the UNIVERSAL manpage was already
doing that, but for everything and everyone).

I decided to work on this adaptation in a new namespace because the Attribute::Handlers manpage
specifically instructs to create subroutines with attributes under the the UNIVERSAL manpage
namespace. Changing this behavior directly in the Attribute::Handlers manpage would
probably break a lot of modules that rely on this already. So, creating
the Attribute::Handlers::Clean manpage seemed like the best option.

This module, when used via `use', automatically makes the caller a subclass,
without the need to specify it in its own `@ISA'. The only case where you
will need to manually add it to your `@ISA', is then you declare `@ISA'
in your class with specific values.

This will also cause an automatic reaction on other modules calling yours,
making your attribute definitions available to all callers and sub-callers
without having to declare them as part of the UNIVERSAL manpage.

If your class `use's `Attribute::Handlers::Clean' but needs to define
its own `import' method, then all...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
