%define module_version 0.003
%define module_name Attribute-QueueStack
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(Devel/StrictMode.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Fatal.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: designate an array as a queue or a stack
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Attribute-QueueStack

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This allows you to designate an array as either a queue or a stack.

Under normal circumstances, it acts as a no-op. In other words, your
array is unaffected by the presence of the attributes.

However, if Perl is run with the `-w' flag, or certain environment
variables are set (see ENVIRONMENT below), Attribute::QueueStack
suddenly goes into deadly mode, and complains if you try to abuse an array
or queue.

Why this state of affairs? Well, this module works via tied arrays.
Perl's `tie' mechanism is pretty slow. So the idea is that you'd want
the slow but strict behaviour in your development and testing environment,
but are happy to have it switched off for speed in your production
environment. (Bugs never occur in your production environment because
of your thorough testing process, right?!)

A constant `Attribute::QueueStack::ARMED' can be used to determine
the state of Attribute::QueueStack.

=begin trustme

=item ARMED

=end trustme


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes COPYRIGHT
%perl_vendor_privlib/A*
%perl_vendor_privlib/T*

%changelog
