# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 Audio-DSP
%define upstream_version 0.02

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt7_28

Summary:	Perl interface to OSS digital audio device
License:	GPL+ or Artistic
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/modules/by-module/Audio/%{upstream_name}-%{upstream_version}.tar.gz
Patch0:		Audio-DSP-0.02-VOCP.patch

BuildRequires:	perl-devel
Source44: import.info


%description
Audio::DSP is built around the OSS (Open Sound System) API and allows perl to
interface with a digital audio device. It provides, among other things, an
initialization method which opens and handles ioctl messaging on the audio
device file. Audio::DSP also provides some rudimentary methods for the storage
and manipulation of audio data in memory.

In order to use Audio::DSP, you'll need to have the necessary OSS
drivers/libraries installed. OSS is available for many popular Unices, and a
GPLed version (with which this extension was initially developed and tested) is
distributed with with the Linux kernel. 

%prep

%setup -q -n %{upstream_name}-%{upstream_version}
%patch0 -p1


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build CFLAGS="%{optflags}"

%install
%makeinstall_std

%files
%doc Changes MANIFEST README
%{perl_vendor_archlib}/Audio
%{perl_vendor_archlib}/auto/Audio


%changelog
